﻿//////////////////////////////////////////////
// DefaultRenderStrategy.h
// 
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class System ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../../Dll/DllDefines.h"

#include "RenderStrategy.h"

// nkMemory
#include <NilkinsMemory/Containers/BufferCast.h>

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT DefaultRenderStrategy final : public RenderStrategy
	{
		public :

			// Structures
			struct SlotEntry final
			{
				const EntityRenderInfoSlot* _slot ;
				Entity* _entity ;
			} ;

		public :

			// Constructor, destructor
			DefaultRenderStrategy () noexcept ;

			// Getters
			const nkMemory::BufferCast<SlotEntry>& getSlots () const ;
			float getLodQualityFactor () const ;
			bool getFrustumCull () const ;
			bool getOrderQueue () const ;
			bool getUseLodSystem () const ;

			// Setters
			void setLodQualityFactor (float value) ;
			void setFrustumCull (bool value) ;
			void setOrderQueue (bool value) ;
			void setUseLodSystem (bool value) ;

			// Execution
			virtual RenderCommandQueue bakeRenderCommandQueue (Shader* shader, bool transparent) override ;

			// Events
			virtual void updateAddRenderSlot (Entity* ent, const EntityRenderInfoSlot* slot) override ;
			virtual void updateEraseRenderSlot (Entity* ent, const EntityRenderInfoSlot* slot) override ;

		private :

			// Attributes
			nkMemory::BufferCast<SlotEntry> _slots ;
			RenderCommandQueue _queue ;
			System* _system ;

			float _lodQualityFactor ;

			bool _frustumCull ;
			bool _orderQueue ;
			bool _useLodSystem ;
	} ;
}